#include <iostream>
#include <vector>
using namespace std;

/*
4
0 1 2 3
3
0 1
0 2
0 3

3
3
0
*/

int bitovi[32];

// O(n * 32) = O(n)
void sredi_bitove(vector<unsigned long long>* b) {
    for(int i = 0; i < 32; i++) {
        bitovi[i] = 0;
    }
    for(int i = 0; i < b->size(); i++) {
        for(int j = 0; j < 32; j++) {
            bitovi[j] += b->at(i) & 1; b->at(i) >>= 1; 
        }
    }
    /*for(int i = 0; i < b->size(); i++) {
        for(int j = 0; j < 32; j++) {
            if(bitovi[j] > 0) {
                b->at(i) += 1 << j;
                bitovi[j]--;
            }
        }
    }*/
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    unsigned long long n, q, zbir = 0, t, k, x;
    vector<unsigned long long> a;
    vector<unsigned long long> b;
    cin >> n;
    a.resize(n);
    b.resize(n);
    for(int i = 0; i < n; i++) {
        cin >> a[i];
        b[i] = a[i];
    }
    
    // Formiranje leksikografski najveceg niza
    // brzina ~ O(C * n)
    sredi_bitove(&b); // success!

    // O(q * 32)!!!!!!
    cin >> q;
    for(int i = 0; i < q; i++) {
        cin >> t >> k;
        if(t == 1) {
            cin >> x;
            int ii = a[k-1] & x;
            unsigned long long dob = x ^ ii;
            int izb = a[k-1] ^ ii;
            for(int j = 0; j < 32; j++) {
                bitovi[j] += (dob >> j) & 1;
            }
            for(int j = 0; j < 32; j++) {
                bitovi[j] -= (izb >> j) & 1;
            }

            a[k-1] = x;
            
            // O(q * n) > limit
            /*for(int j = 0; j < n; j++) {
                b[j] = a[j];
            }*/
            // odredi_najveci_niz(&b);
        }
        else { // t = 0
            unsigned long long odg = 0;
            for(int j = 0; j < 32; j++) { // holup... let me cook
                if(bitovi[j] >= k) {
                    odg += 1 << j;
                }
            }
            cout << odg << '\n';
        }
    }

    return 0;
}